const $ = (id) => document.getElementById(id);

function setStatus(obj) {
  const el = $("status");
  el.textContent = typeof obj === "string" ? obj : JSON.stringify(obj, null, 2);
}

async function postJSON(url, body) {
  const r = await fetch(url, {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify(body || {})
  });
  const data = await r.json().catch(() => ({}));
  if (!r.ok) throw new Error(data?.error || `Request failed (${r.status})`);
  return data;
}

$("btnCall").addEventListener("click", async () => {
  try {
    const api = $("apiBase").value.replace(/\/$/, "");
    const to = $("toNumber").value.trim();
    if (!to) return setStatus("Enter a phone number in E.164 format, like +17135551234");
    setStatus("Calling...");
    const data = await postJSON(`${api}/api/call`, { to });
    setStatus(data);
  } catch (e) {
    setStatus({ ok: false, error: e.message });
  }
});

$("btnHangup").addEventListener("click", async () => {
  try {
    const api = $("apiBase").value.replace(/\/$/, "");
    setStatus("Hanging up...");
    const data = await postJSON(`${api}/api/hangup`, {});
    setStatus(data);
  } catch (e) {
    setStatus({ ok: false, error: e.message });
  }
});
